/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.client.model;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BipedJsonModel
extends ModelBiped {
    public boolean hasEffect;
    public int colorDecimal;
    public ItemCameraTransforms.TransformType tranformType;
    public ModelResourceLocation modelResourceLocation;
    private IItemColor itemColorer;
    public boolean equippedAsAccessory = false;
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public BipedJsonModel(ResourceLocation modelLocation) {
        this(modelLocation, ItemCameraTransforms.TransformType.HEAD);
    }

    public BipedJsonModel(ResourceLocation modelLocation, ItemCameraTransforms.TransformType type) {
        this(modelLocation, type, -1);
    }

    public BipedJsonModel(ResourceLocation modelLocation, ItemCameraTransforms.TransformType type, int color) {
        this(modelLocation, "inventory", type, color, false);
    }

    public BipedJsonModel(ResourceLocation modelLocation, String variant, ItemCameraTransforms.TransformType type, int color, boolean hasEffect) {
        this.field_78090_t = 16;
        this.field_78089_u = 16;
        this.hasEffect = hasEffect;
        this.colorDecimal = color;
        this.tranformType = type;
        this.modelResourceLocation = new ModelResourceLocation(modelLocation, variant);
        this.itemColorer = new Colorer(this.colorDecimal);
    }

    protected float interpolateRotation(float prevYawOffset, float yawOffset, float partialTicks) {
        float f;
        for (f = yawOffset - prevYawOffset; f < -180.0f; f += 360.0f) {
        }
        while (f >= 180.0f) {
            f -= 360.0f;
        }
        return prevYawOffset + partialTicks * f;
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float yaw, float pitch, float scale) {
        float sneak = this.field_78117_n ? 0.2f : 0.0f;
        RenderItem renderer = Minecraft.func_71410_x().func_175599_af();
        TextureManager texManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179094_E();
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, yaw, pitch, scale, entity);
        GlStateManager.func_179109_b((float)0.0f, (float)sneak, (float)0.0f);
        if (!this.equippedAsAccessory) {
            if (this.tranformType == ItemCameraTransforms.TransformType.HEAD) {
                this.field_78116_c.func_78794_c(scale);
            } else {
                this.field_78115_e.func_78794_c(scale);
            }
        }
        try {
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IBakedModel model = renderer.func_175037_a().func_178083_a().func_174953_a(this.modelResourceLocation);
            if (model != null) {
                model = model.func_188617_f().handleItemState(model, ItemStack.field_190927_a, (World)null, (EntityLivingBase)null);
                model.handlePerspective(this.tranformType);
                texManager.func_110577_a(TextureMap.field_110575_b);
                texManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179091_B();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)this.tranformType, (boolean)false);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.0f, (float)-0.5f);
                if (!model.func_188618_c()) {
                    this.renderModel(renderer, model, this.colorDecimal, ItemStack.field_190927_a);
                    if (this.hasEffect) {
                        this.renderEffect(renderer, model);
                    }
                }
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                GlStateManager.func_179121_F();
                GlStateManager.func_179101_C();
                GlStateManager.func_179084_k();
                texManager.func_110577_a(TextureMap.field_110575_b);
                texManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
                GlStateManager.func_179094_E();
            }
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlStateManager.func_179121_F();
    }

    private void renderModel(RenderItem renderer, IBakedModel model, int color) {
        this.renderModel(renderer, model, color, ItemStack.field_190927_a);
    }

    private void renderModel(RenderItem renderer, IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            this.renderQuads(renderer, bufferbuilder, model.func_188616_a((IBlockState)null, enumfacing, 0L), color, stack);
        }
        this.renderQuads(renderer, bufferbuilder, model.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    public void renderQuads(RenderItem renderer, BufferBuilder buffer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1;
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = this.itemColorer.func_186726_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)bakedquad, (int)k);
        }
    }

    private void renderEffect(RenderItem renderer, IBakedModel model) {
        TextureManager texManager = Minecraft.func_71410_x().func_110434_K();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        texManager.func_110577_a(RES_ITEM_GLINT);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(renderer, model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(renderer, model, -8372020);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        texManager.func_110577_a(TextureMap.field_110575_b);
    }

    @SideOnly(value=Side.CLIENT)
    private static class Colorer
    implements IItemColor {
        int color;

        public Colorer(int color) {
            this.color = color;
        }

        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            if (tintIndex == 1) {
                return -1;
            }
            return this.color;
        }
    }
}

